##Processing
#To import and clean data

impclean <- function(path, sheet_name, values_to_new){
  df<- read_excel(path, sheet = sheet_name, skip =2)
  colnames(df)[c(2,3)] <- c("country", "year")
  df <- df %>%
    filter(!is.na(.data[["country"]]))%>%
    pivot_longer(
      cols = January:December,
      names_to = "month",
      values_to = values_to_new)%>%
    select(country, year, month, values_to_new)%>%
    pivot_wider(
      names_from = year,
      values_from = values_to_new,
      names_prefix = paste0(values_to_new, "_"))
  return (df)
}

IM_data <- impclean(path_to_IM, "CIF Import Value", "cifval")
EX_data <- impclean(path_to_EX, "FAS Value", "expval")


#EU: Austria, Belgium, Bulgaria, Croatia, Cyprus, Czechia (Czech Republic), Denmark, Estonia, Finland, France, Germany, Greece, Hungary, Ireland, Italy, Latvia, Lithuania, Luxembourg, Malta, Netherlands, Poland, Portugal, Romania, Slovakia, Slovenia, Spain, Sweden

eu27 <- c(
  "Austria", "Belgium", "Bulgaria", "Croatia", "Cyprus", 
  "Czechia (Czech Republic)", "Denmark", "Estonia", "Finland", 
  "France", "Germany", "Greece", "Hungary", "Ireland", "Italy", 
  "Latvia", "Lithuania", "Luxembourg", "Malta", "Netherlands", 
  "Poland", "Portugal", "Romania", "Slovakia", "Slovenia", 
  "Spain", "Sweden"
)

major_partners <-c(
  "China", "Japan", "South Korea", "Canada", "Mexico", "United Kingdom"
)
